/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.sideeffect;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffect;
import org.eclipse.core.runtime.Assert;

public final class CompositeSideEffect
implements ISideEffect {
    private final List<ISideEffect> sideEffects;
    private int pauseDepth;
    private boolean isDisposed;
    private final Realm realm;
    private List<Consumer<ISideEffect>> disposeListeners;
    private final Consumer<ISideEffect> removalConsumer = this::remove;

    public CompositeSideEffect() {
        this.realm = Realm.getDefault();
        this.sideEffects = new ArrayList<ISideEffect>();
    }

    private void checkRealm() {
        Assert.isTrue((boolean)this.realm.isCurrent(), (String)"This operation must be run within the observable's realm");
    }

    @Override
    public void dispose() {
        this.checkRealm();
        if (this.isDisposed) {
            return;
        }
        this.sideEffects.forEach(s -> s.removeDisposeListener(this.removalConsumer));
        this.sideEffects.forEach(ISideEffect::dispose);
        this.sideEffects.clear();
        this.isDisposed = true;
        if (this.disposeListeners != null) {
            List<Consumer<ISideEffect>> listeners = this.disposeListeners;
            this.disposeListeners = null;
            listeners.forEach(dc -> dc.accept(this));
        }
    }

    @Override
    public boolean isDisposed() {
        this.checkRealm();
        return this.isDisposed;
    }

    @Override
    public void addDisposeListener(Consumer<ISideEffect> disposalConsumer) {
        this.checkRealm();
        if (this.isDisposed()) {
            return;
        }
        if (this.disposeListeners == null) {
            this.disposeListeners = new ArrayList<Consumer<ISideEffect>>();
        }
        this.disposeListeners.add(disposalConsumer);
    }

    @Override
    public void removeDisposeListener(Consumer<ISideEffect> disposalConsumer) {
        this.checkRealm();
        if (this.disposeListeners == null) {
            return;
        }
        this.disposeListeners.remove(disposalConsumer);
    }

    @Override
    public void pause() {
        this.checkRealm();
        ++this.pauseDepth;
        if (this.pauseDepth == 1) {
            this.sideEffects.forEach(ISideEffect::pause);
        }
    }

    @Override
    public void resume() {
        this.checkRealm();
        --this.pauseDepth;
        if (this.pauseDepth < 0) {
            throw new IllegalStateException("The resume() method was called more times than pause().");
        }
        if (this.pauseDepth == 0) {
            this.sideEffects.forEach(ISideEffect::resume);
        }
    }

    @Override
    public void resumeAndRunIfDirty() {
        this.checkRealm();
        --this.pauseDepth;
        if (this.pauseDepth == 0) {
            this.sideEffects.forEach(ISideEffect::resumeAndRunIfDirty);
        }
    }

    @Override
    public void runIfDirty() {
        this.checkRealm();
        if (this.pauseDepth <= 0) {
            this.sideEffects.forEach(ISideEffect::runIfDirty);
        }
    }

    public void add(ISideEffect sideEffect) {
        this.checkRealm();
        if (!sideEffect.isDisposed()) {
            this.sideEffects.add(sideEffect);
            if (this.pauseDepth > 0) {
                sideEffect.pause();
            }
            sideEffect.addDisposeListener(this.removalConsumer);
        }
    }

    public void remove(ISideEffect sideEffect) {
        this.checkRealm();
        this.sideEffects.remove(sideEffect);
        if (!sideEffect.isDisposed()) {
            if (this.pauseDepth > 0) {
                sideEffect.resume();
            }
            sideEffect.removeDisposeListener(this.removalConsumer);
        }
    }
}

