/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account.resources;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.resources.account.resources.AbstractResourceService;
import org.keycloak.services.resources.account.resources.ResourceService;

public class ResourcesService
extends AbstractResourceService {
    public ResourcesService(KeycloakSession session, UserModel user, Auth auth, HttpRequest request) {
        super(session, user, auth, request);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getResources(@QueryParam(value="name") String name, @QueryParam(value="first") Integer first, @QueryParam(value="max") Integer max) {
        EnumMap<Resource.FilterOption, String[]> filters = new EnumMap<Resource.FilterOption, String[]>(Resource.FilterOption.class);
        filters.put(Resource.FilterOption.OWNER, new String[]{this.user.getId()});
        if (name != null) {
            filters.put(Resource.FilterOption.NAME, new String[]{name});
        }
        return this.queryResponse((f, m) -> this.resourceStore.find(null, filters, f, m).stream().map(resource -> new AbstractResourceService.Resource((Resource)resource, this.user, this.provider)), first, max);
    }

    @GET
    @Path(value="shared-with-me")
    @Produces(value={"application/json"})
    public Response getSharedWithMe(@QueryParam(value="name") String name, @QueryParam(value="first") Integer first, @QueryParam(value="max") Integer max) {
        return this.queryResponse((f, m) -> this.toPermissions(this.ticketStore.findGrantedResources(this.auth.getUser().getId(), name, f, m), false).stream(), first, max);
    }

    @GET
    @Path(value="shared-with-others")
    @Produces(value={"application/json"})
    public Response getSharedWithOthers(@QueryParam(value="first") Integer first, @QueryParam(value="max") Integer max) {
        return this.queryResponse((f, m) -> this.toPermissions(this.ticketStore.findGrantedOwnerResources(this.auth.getUser().getId(), f, m), true).stream(), first, max);
    }

    @GET
    @Path(value="pending-requests")
    @Produces(value={"application/json"})
    public Response getPendingRequests() {
        EnumMap<PermissionTicket.FilterOption, String> filters = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
        filters.put(PermissionTicket.FilterOption.REQUESTER, this.user.getId());
        filters.put(PermissionTicket.FilterOption.GRANTED, Boolean.FALSE.toString());
        List permissionTickets = this.ticketStore.find(null, filters, null, null);
        ArrayList<AbstractResourceService.ResourcePermission> resourceList = new ArrayList<AbstractResourceService.ResourcePermission>(permissionTickets.size());
        for (PermissionTicket ticket : permissionTickets) {
            AbstractResourceService.ResourcePermission resourcePermission = new AbstractResourceService.ResourcePermission(ticket.getResource(), this.provider);
            resourcePermission.addScope(new AbstractResourceService.Scope(ticket.getScope()));
            resourceList.add(resourcePermission);
        }
        return this.queryResponse((f, m) -> resourceList.stream(), -1, resourceList.size());
    }

    @Path(value="{id}")
    public Object getResource(@PathParam(value="id") String id) {
        Resource resource = this.resourceStore.findById(null, id);
        if (resource == null) {
            throw new NotFoundException("resource_not_found");
        }
        if (!resource.getOwner().equals(this.user.getId())) {
            throw new BadRequestException("invalid_resource");
        }
        return new ResourceService(resource, this.provider.getKeycloakSession(), this.user, this.auth, this.request);
    }

    private Collection<AbstractResourceService.ResourcePermission> toPermissions(List<Resource> resources, boolean withRequesters) {
        ArrayList<AbstractResourceService.ResourcePermission> permissions = new ArrayList<AbstractResourceService.ResourcePermission>();
        PermissionTicketStore ticketStore = this.provider.getStoreFactory().getPermissionTicketStore();
        for (Resource resource : resources) {
            List tickets;
            AbstractResourceService.ResourcePermission permission = new AbstractResourceService.ResourcePermission(resource, this.provider);
            if (withRequesters) {
                EnumMap<PermissionTicket.FilterOption, String> filters = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
                filters.put(PermissionTicket.FilterOption.OWNER, this.user.getId());
                filters.put(PermissionTicket.FilterOption.GRANTED, Boolean.TRUE.toString());
                filters.put(PermissionTicket.FilterOption.RESOURCE_ID, resource.getId());
                tickets = ticketStore.find(resource.getResourceServer(), filters, null, null);
            } else {
                tickets = ticketStore.findGranted(resource.getResourceServer(), resource.getName(), this.user.getId());
            }
            for (PermissionTicket ticket : tickets) {
                if (!resource.equals((Object)ticket.getResource())) continue;
                if (withRequesters) {
                    AbstractResourceService.Permission user = permission.getPermission(ticket.getRequester());
                    if (user == null) {
                        user = new AbstractResourceService.Permission(ticket.getRequester(), this.provider);
                        permission.addPermission(ticket.getRequester(), user);
                    }
                    user.addScope(ticket.getScope().getName());
                    continue;
                }
                permission.addScope(new AbstractResourceService.Scope(ticket.getScope()));
            }
            permissions.add(permission);
        }
        return permissions;
    }

    private Response queryResponse(BiFunction<Integer, Integer, Stream<?>> query, Integer first, Integer max) {
        if (first != null && max != null) {
            List result = query.apply(first, max + 1).collect(Collectors.toList());
            int size = result.size();
            if (size > max) {
                result = result.subList(0, size - 1);
            }
            return Response.ok().entity(result).links(this.createPageLinks(first, max, size)).build();
        }
        return Response.ok().entity(query.apply(-1, -1).collect(Collectors.toList())).build();
    }

    private Link[] createPageLinks(Integer first, Integer max, int resultSize) {
        boolean nextPage;
        if (resultSize == 0 || first == 0 && resultSize <= max) {
            return new Link[0];
        }
        ArrayList<Link> links = new ArrayList<Link>();
        boolean bl = nextPage = resultSize > max;
        if (nextPage) {
            links.add(Link.fromUri((URI)KeycloakUriBuilder.fromUri((URI)this.uriInfo.getRequestUri()).replaceQuery("first={first}&max={max}").build(new Object[]{first + max, max})).rel("next").build(new Object[0]));
        }
        if (first > 0) {
            links.add(Link.fromUri((URI)KeycloakUriBuilder.fromUri((URI)this.uriInfo.getRequestUri()).replaceQuery("first={first}&max={max}").build(new Object[]{Math.max(first - max, 0), max})).rel("prev").build(new Object[0]));
        }
        return links.toArray(new Link[links.size()]);
    }
}

