/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public class HighDegreeNodeLayeringProcessor
implements ILayoutProcessor<LGraph> {
    private static final Function<LNode, Iterable<LEdge>> INCOMING_EDGES = n -> n.getIncomingEdges();
    private static final Function<LNode, Iterable<LEdge>> OUTGOING_EDGES = n -> n.getOutgoingEdges();
    private LGraph layeredGraph;
    private int degreeThreshold;
    private int treeHeightThreshold;

    /*
     * WARNING - void declaration
     */
    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        this.layeredGraph = graph;
        this.degreeThreshold = graph.getProperty(LayeredOptions.HIGH_DEGREE_NODES_THRESHOLD);
        this.treeHeightThreshold = graph.getProperty(LayeredOptions.HIGH_DEGREE_NODES_TREE_HEIGHT);
        if (this.treeHeightThreshold == 0) {
            this.treeHeightThreshold = Integer.MAX_VALUE;
        }
        ListIterator<Layer> layerIt = graph.getLayers().listIterator();
        while (layerIt.hasNext()) {
            void var10_17;
            void var9_12;
            Layer lay = layerIt.next();
            ArrayList<Pair<LNode, HighDegreeNodeInformation>> highDegreeNodes = Lists.newArrayList();
            int incMax = -1;
            int outMax = -1;
            for (LNode n : lay.getNodes()) {
                if (!this.isHighDegreeNode(n)) continue;
                HighDegreeNodeInformation highDegreeNodeInformation = this.calculateInformation(n);
                incMax = Math.max(incMax, highDegreeNodeInformation.incTreesMaxHeight);
                outMax = Math.max(outMax, highDegreeNodeInformation.outTreesMaxHeight);
                highDegreeNodes.add(Pair.of(n, highDegreeNodeInformation));
            }
            ArrayList<Layer> preLayers = Lists.newArrayList();
            boolean bl = false;
            while (var9_12 < incMax) {
                preLayers.add(0, this.prependLayer(layerIt));
                ++var9_12;
            }
            for (Pair pair : highDegreeNodes) {
                List<LNode> incRoots = ((HighDegreeNodeInformation)pair.getSecond()).incTreeRoots;
                if (incRoots == null) continue;
                for (LNode incRoot : incRoots) {
                    this.moveTree(incRoot, INCOMING_EDGES, preLayers);
                }
            }
            ArrayList<Layer> arrayList = Lists.newArrayList();
            boolean bl2 = false;
            while (var10_17 < outMax) {
                arrayList.add(this.appendLayer(layerIt));
                ++var10_17;
            }
            for (Pair pair : highDegreeNodes) {
                List<LNode> outRoots = ((HighDegreeNodeInformation)pair.getSecond()).outTreeRoots;
                if (outRoots == null) continue;
                for (LNode outRoot : outRoots) {
                    this.moveTree(outRoot, OUTGOING_EDGES, arrayList);
                }
            }
        }
        ListIterator<Layer> layerIt2 = graph.getLayers().listIterator();
        while (layerIt2.hasNext()) {
            Layer l = layerIt2.next();
            if (!l.getNodes().isEmpty()) continue;
            layerIt2.remove();
        }
    }

    private boolean isHighDegreeNode(LNode node) {
        return HighDegreeNodeLayeringProcessor.degree(node) >= this.degreeThreshold;
    }

    private HighDegreeNodeInformation calculateInformation(LNode hdn) {
        int treeHeight;
        HighDegreeNodeInformation hdni = new HighDegreeNodeInformation();
        for (LEdge incEdge : hdn.getIncomingEdges()) {
            LNode src;
            if (incEdge.isSelfLoop() || !this.hasSingleConnection(src = incEdge.getSource().getNode(), OUTGOING_EDGES) || (treeHeight = this.isTreeRoot(src, OUTGOING_EDGES, INCOMING_EDGES)) == -1) continue;
            hdni.incTreesMaxHeight = Math.max(hdni.incTreesMaxHeight, treeHeight);
            if (hdni.incTreeRoots == null) {
                hdni.incTreeRoots = Lists.newArrayList();
            }
            hdni.incTreeRoots.add(src);
        }
        for (LEdge outEdge : hdn.getOutgoingEdges()) {
            LNode tgt;
            if (outEdge.isSelfLoop() || !this.hasSingleConnection(tgt = outEdge.getTarget().getNode(), INCOMING_EDGES) || (treeHeight = this.isTreeRoot(tgt, INCOMING_EDGES, OUTGOING_EDGES)) == -1) continue;
            hdni.outTreesMaxHeight = Math.max(hdni.outTreesMaxHeight, treeHeight);
            if (hdni.outTreeRoots == null) {
                hdni.outTreeRoots = Lists.newArrayList();
            }
            hdni.outTreeRoots.add(tgt);
        }
        return hdni;
    }

    private Layer prependLayer(ListIterator<Layer> layerIt) {
        assert (layerIt.hasPrevious());
        layerIt.previous();
        Layer l = new Layer(this.layeredGraph);
        layerIt.add(l);
        layerIt.next();
        return l;
    }

    private Layer appendLayer(ListIterator<Layer> layerIt) {
        Layer l = new Layer(this.layeredGraph);
        layerIt.add(l);
        return l;
    }

    private void moveTree(LNode root, Function<LNode, Iterable<LEdge>> edgesFun, List<Layer> layers) {
        assert (layers.size() > 0);
        root.setLayer(layers.get(0));
        List<Layer> subList = layers.subList(1, layers.size());
        for (LEdge e : edgesFun.apply(root)) {
            LNode other = this.other(e, root);
            this.moveTree(other, edgesFun, subList);
        }
    }

    private static int degree(LNode node) {
        return HighDegreeNodeLayeringProcessor.degree(node, n -> n.getConnectedEdges());
    }

    private static int degree(LNode node, Function<LNode, Iterable<LEdge>> edgeSelector) {
        return Iterables.size(edgeSelector.apply(node));
    }

    private boolean hasSingleConnection(LNode node, Function<LNode, Iterable<LEdge>> edgeSelector) {
        LNode connection = null;
        for (LEdge e : edgeSelector.apply(node)) {
            if (connection == null) {
                connection = this.other(e, node);
                continue;
            }
            if (this.other(e, node) == connection) continue;
            return false;
        }
        return true;
    }

    private LNode other(LEdge edge, LNode node) {
        if (edge.getSource().getNode() == node) {
            return edge.getTarget().getNode();
        }
        return edge.getSource().getNode();
    }

    private int isTreeRoot(LNode root, Function<LNode, Iterable<LEdge>> ancestorEdges, Function<LNode, Iterable<LEdge>> descendantEdges) {
        if (this.isHighDegreeNode(root)) {
            return -1;
        }
        if (!this.hasSingleConnection(root, ancestorEdges)) {
            return -1;
        }
        if (Iterables.isEmpty(descendantEdges.apply(root))) {
            return 1;
        }
        int currentHeight = 0;
        for (LEdge e : descendantEdges.apply(root)) {
            LNode other = this.other(e, root);
            int height = this.isTreeRoot(other, ancestorEdges, descendantEdges);
            if (height == -1) {
                return -1;
            }
            if ((currentHeight = Math.max(currentHeight, height)) <= this.treeHeightThreshold - 1) continue;
            return -1;
        }
        return currentHeight + 1;
    }

    private class HighDegreeNodeInformation {
        int incTreesMaxHeight = -1;
        List<LNode> incTreeRoots;
        int outTreesMaxHeight = -1;
        List<LNode> outTreeRoots;

        private HighDegreeNodeInformation() {
        }
    }
}

