/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.common.SolrException;

public class DecimalNumericConversionFunction {
    public static LongValueStream createDecimalConversionFunction(String name, ConvertFloatFunction fconv, ConvertDoubleFunction dconv, AnalyticsValueStream ... params) {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires 1 paramaters, " + params.length + " found.");
        }
        AnalyticsValueStream param = params[0];
        if (param instanceof LongValueStream) {
            return (LongValueStream)param;
        }
        if (param instanceof FloatValueStream) {
            if (param instanceof FloatValue) {
                return new ConvertFloatValueFunction(name, (FloatValue)param, fconv);
            }
            return new ConvertFloatStreamFunction(name, (FloatValueStream)param, fconv);
        }
        if (param instanceof DoubleValueStream) {
            if (param instanceof DoubleValue) {
                return new ConvertDoubleValueFunction(name, (DoubleValue)param, dconv);
            }
            return new ConvertDoubleStreamFunction(name, (DoubleValueStream)param, dconv);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires a numeric parameter.");
    }

    static class ConvertDoubleStreamFunction
    extends LongValueStream.AbstractLongValueStream {
        private final String name;
        private final DoubleValueStream param;
        private final ConvertDoubleFunction conv;
        private final String funcStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public ConvertDoubleStreamFunction(String name, DoubleValueStream param, ConvertDoubleFunction conv) {
            this.name = name;
            this.param = param;
            this.conv = conv;
            this.funcStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, param);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            this.param.streamDoubles(value -> cons.accept(this.conv.convert(value)));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.funcStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class ConvertDoubleValueFunction
    extends LongValue.AbstractLongValue {
        private final String name;
        private final DoubleValue param;
        private final ConvertDoubleFunction conv;
        private final String funcStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public ConvertDoubleValueFunction(String name, DoubleValue param, ConvertDoubleFunction conv) {
            this.name = name;
            this.param = param;
            this.conv = conv;
            this.funcStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, param);
        }

        @Override
        public long getLong() {
            return this.conv.convert(this.param.getDouble());
        }

        @Override
        public boolean exists() {
            return this.param.exists();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.funcStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class ConvertFloatStreamFunction
    extends IntValueStream.AbstractIntValueStream {
        private final String name;
        private final FloatValueStream param;
        private final ConvertFloatFunction conv;
        private final String funcStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public ConvertFloatStreamFunction(String name, FloatValueStream param, ConvertFloatFunction conv) {
            this.name = name;
            this.param = param;
            this.conv = conv;
            this.funcStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, param);
        }

        @Override
        public void streamInts(IntConsumer cons) {
            this.param.streamFloats(value -> cons.accept(this.conv.convert(value)));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.funcStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class ConvertFloatValueFunction
    extends IntValue.AbstractIntValue {
        private final String name;
        private final FloatValue param;
        private final ConvertFloatFunction conv;
        private final String funcStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public ConvertFloatValueFunction(String name, FloatValue param, ConvertFloatFunction conv) {
            this.name = name;
            this.param = param;
            this.conv = conv;
            this.funcStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, param);
        }

        @Override
        public int getInt() {
            return this.conv.convert(this.param.getFloat());
        }

        @Override
        public boolean exists() {
            return this.param.exists();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.funcStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    @FunctionalInterface
    public static interface ConvertDoubleFunction {
        public long convert(double var1);
    }

    @FunctionalInterface
    public static interface ConvertFloatFunction {
        public int convert(float var1);
    }

    public static class RoundFunction {
        public static final String name = "round";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> DecimalNumericConversionFunction.createDecimalConversionFunction(name, val -> Math.round(val), val -> Math.round(val), params);
    }

    public static class CeilingFunction {
        public static final String name = "ceil";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> DecimalNumericConversionFunction.createDecimalConversionFunction(name, val -> (int)Math.ceil(val), val -> (long)Math.ceil(val), params);
    }

    public static class FloorFunction {
        public static final String name = "floor";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> DecimalNumericConversionFunction.createDecimalConversionFunction(name, val -> (int)Math.floor(val), val -> (long)Math.floor(val), params);
    }
}

