/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.reifier;

import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.TransformDefinition;
import org.apache.camel.processor.TransformProcessor;
import org.apache.camel.processor.transformer.DataTypeProcessor;

public class TransformReifier extends ExpressionReifier<TransformDefinition> {

    public TransformReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (TransformDefinition) definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        if (definition.getExpression() != null && definition.getToType() != null) {
            throw new IllegalArgumentException(
                    "Both expression and data type set on transform EIP - please choose only one of them");
        }
        if (definition.getToType() != null) {
            return new DataTypeProcessor(definition.getFromType(), definition.getToType());
        }

        Expression expr = createExpression(definition.getExpression());
        TransformProcessor answer = new TransformProcessor(expr);
        answer.setDisabled(isDisabled(camelContext, definition));
        return answer;
    }
}
