/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress;

import java.io.IOException;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BlockDecompressorHelper {
    public static int decompress(ByteBuff output, ByteBuff input, int inputSize, RawDecompressor rawDecompressor) throws IOException {
        int totalDecompressedBytes = 0;
        int compressedBytesConsumed = 0;
        while (compressedBytesConsumed < inputSize) {
            int decompressedBlockSize = BlockDecompressorHelper.rawReadInt(input);
            compressedBytesConsumed += 4;
            int decompressedBytesInBlock = 0;
            while (decompressedBytesInBlock < decompressedBlockSize) {
                int compressedChunkSize = BlockDecompressorHelper.rawReadInt(input);
                compressedBytesConsumed += 4;
                int n = rawDecompressor.decompress(output, input, compressedChunkSize);
                if (n <= 0) {
                    throw new IOException("Decompression failed. Compressed size: " + compressedChunkSize + ", decompressed size: " + decompressedBlockSize);
                }
                compressedBytesConsumed += compressedChunkSize;
                decompressedBytesInBlock += n;
                totalDecompressedBytes += n;
            }
        }
        return totalDecompressedBytes;
    }

    private static int rawReadInt(ByteBuff input) {
        int b1 = Byte.toUnsignedInt(input.get());
        int b2 = Byte.toUnsignedInt(input.get());
        int b3 = Byte.toUnsignedInt(input.get());
        int b4 = Byte.toUnsignedInt(input.get());
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    public static interface RawDecompressor {
        public int decompress(ByteBuff var1, ByteBuff var2, int var3) throws IOException;
    }
}

