/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.JavaScriptRequestChecker;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.TenantConfigResolver;
import io.quarkus.oidc.TenantResolver;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.runtime.BackChannelLogoutTokenCache;
import io.quarkus.oidc.runtime.BlockingTaskRunner;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.StaticTenantResolver;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DefaultTenantConfigResolver {
    private static final Logger LOG = Logger.getLogger(DefaultTenantConfigResolver.class);
    private static final String CURRENT_STATIC_TENANT_ID = "static.tenant.id";
    private static final String CURRENT_STATIC_TENANT_ID_NULL = "static.tenant.id.null";
    private static final String CURRENT_DYNAMIC_TENANT_CONFIG = "dynamic.tenant.config";
    private final ConcurrentHashMap<String, BackChannelLogoutTokenCache> backChannelLogoutTokens;
    private final BlockingTaskRunner<OidcTenantConfig> blockingRequestContext;
    private final boolean securityEventObserved;
    private final TenantConfigBean tenantConfigBean;
    private final boolean annotationBasedTenantResolutionEnabled;
    private final String rootPath;
    private final StaticTenantResolver staticTenantResolver;
    @Inject
    Instance<TenantConfigResolver> tenantConfigResolver;
    @Inject
    Instance<JavaScriptRequestChecker> javaScriptRequestChecker;
    @Inject
    Instance<TokenStateManager> tokenStateManager;
    @Inject
    Instance<TokenIntrospectionCache> tokenIntrospectionCache;
    @Inject
    Instance<UserInfoCache> userInfoCache;
    @Inject
    Event<SecurityEvent> securityEvent;
    @Inject
    @ConfigProperty(name="quarkus.http.proxy.enable-forwarded-prefix")
    boolean enableHttpForwardedPrefix;

    DefaultTenantConfigResolver(BlockingSecurityExecutor blockingExecutor, BeanManager beanManager, Instance<TenantResolver> tenantResolverInstance, @ConfigProperty(name="quarkus.oidc.resolve-tenants-with-issuer") boolean resolveTenantsWithIssuer, @ConfigProperty(name="quarkus.security.events.enabled") boolean securityEventsEnabled, @ConfigProperty(name="quarkus.http.root-path") String rootPath, TenantConfigBean tenantConfigBean) {
        this.backChannelLogoutTokens = new ConcurrentHashMap();
        this.blockingRequestContext = new BlockingTaskRunner(blockingExecutor);
        this.securityEventObserved = SecurityEventHelper.isEventObserved((io.quarkus.security.spi.runtime.SecurityEvent)new SecurityEvent(null, (SecurityIdentity)null), (BeanManager)beanManager, (boolean)securityEventsEnabled);
        this.tenantConfigBean = tenantConfigBean;
        this.annotationBasedTenantResolutionEnabled = Boolean.getBoolean("io.quarkus.oidc.runtime.select-tenants-with-annotation");
        this.rootPath = rootPath;
        this.staticTenantResolver = new StaticTenantResolver(tenantConfigBean, rootPath, resolveTenantsWithIssuer, tenantResolverInstance);
    }

    @PostConstruct
    public void verifyResolvers() {
        if (this.tenantConfigResolver.isResolvable() && this.tenantConfigResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + String.valueOf(TenantConfigResolver.class) + " beans registered");
        }
        if (this.tokenStateManager.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + String.valueOf(TokenStateManager.class) + " beans registered");
        }
        if (this.tokenIntrospectionCache.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + String.valueOf(TokenIntrospectionCache.class) + " beans registered");
        }
        if (this.userInfoCache.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + String.valueOf(UserInfo.class) + " beans registered");
        }
        if (this.javaScriptRequestChecker.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + String.valueOf(JavaScriptRequestChecker.class) + " beans registered");
        }
    }

    Uni<OidcTenantConfig> resolveConfig(RoutingContext context) {
        return this.getDynamicTenantConfig(context).flatMap((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    Uni<TenantConfigContext> resolveContext(String tenantId) {
        return this.initializeStaticTenantIfContextNotReady(this.getStaticTenantContext(tenantId));
    }

    Uni<TenantConfigContext> resolveContext(RoutingContext context) {
        return this.getDynamicTenantContext(context).flatMap((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Uni<TenantConfigContext> initializeStaticTenantIfContextNotReady(TenantConfigContext tenantContext) {
        if (tenantContext != null && !tenantContext.ready()) {
            return tenantContext.initialize();
        }
        return Uni.createFrom().item((Object)tenantContext);
    }

    private Uni<TenantConfigContext> getStaticTenantContext(RoutingContext context) {
        String tenantId = (String)context.get(CURRENT_STATIC_TENANT_ID);
        if (tenantId != null) {
            return Uni.createFrom().item((Object)this.getStaticTenantContext(tenantId));
        }
        if (context.get(CURRENT_STATIC_TENANT_ID_NULL) == null) {
            return this.resolveStaticTenantId(context).map((Function)new /* Unavailable Anonymous Inner Class!! */);
        }
        return Uni.createFrom().item((Object)this.getStaticTenantContext((String)null));
    }

    private Uni<String> resolveStaticTenantId(RoutingContext context) {
        String tenantId = (String)context.get("tenant-id");
        if (this.isTenantSetByAnnotation(context, tenantId)) {
            return Uni.createFrom().item((Object)tenantId);
        }
        return this.staticTenantResolver.resolve(context).map((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isTenantSetByAnnotation(RoutingContext context, String tenantId) {
        return this.annotationBasedTenantResolutionEnabled && tenantId != null && context.get("tenant-id-set-by-annotation") != null;
    }

    private TenantConfigContext getStaticTenantContext(String tenantId) {
        TenantConfigContext configContext;
        TenantConfigContext tenantConfigContext = configContext = tenantId != null ? this.tenantConfigBean.getStaticTenant(tenantId) : null;
        if (configContext == null) {
            if (tenantId != null && !tenantId.isEmpty() && !"Default".equals(tenantId)) {
                LOG.debugf("Registered TenantResolver has not provided the configuration for tenant '%s', using the default tenant", (Object)tenantId);
            }
            configContext = this.tenantConfigBean.getDefaultTenant();
        }
        return configContext;
    }

    boolean isSecurityEventObserved() {
        return this.securityEventObserved;
    }

    Event<SecurityEvent> getSecurityEvent() {
        return this.securityEvent;
    }

    TokenStateManager getTokenStateManager() {
        return (TokenStateManager)this.tokenStateManager.get();
    }

    TokenIntrospectionCache getTokenIntrospectionCache() {
        return this.tokenIntrospectionCache.isResolvable() ? (TokenIntrospectionCache)this.tokenIntrospectionCache.get() : null;
    }

    UserInfoCache getUserInfoCache() {
        return this.userInfoCache.isResolvable() ? (UserInfoCache)this.userInfoCache.get() : null;
    }

    private Uni<OidcTenantConfig> getDynamicTenantConfig(RoutingContext context) {
        if (this.isTenantSetByAnnotation(context, (String)context.get("tenant-id"))) {
            return Uni.createFrom().nullItem();
        }
        if (this.tenantConfigResolver.isResolvable()) {
            Uni oidcConfig = (Uni)context.get(CURRENT_DYNAMIC_TENANT_CONFIG);
            if (oidcConfig == null) {
                oidcConfig = ((TenantConfigResolver)this.tenantConfigResolver.get()).resolve(context, this.blockingRequestContext);
                if (oidcConfig == null) {
                    oidcConfig = Uni.createFrom().nullItem();
                }
                oidcConfig = (oidcConfig = oidcConfig.memoize().indefinitely()) == null ? Uni.createFrom().nullItem() : oidcConfig.onItem().transform(cfg -> OidcUtils.resolveProviderConfig((OidcTenantConfig)cfg));
                context.put(CURRENT_DYNAMIC_TENANT_CONFIG, (Object)oidcConfig);
            }
            return oidcConfig;
        }
        return Uni.createFrom().nullItem();
    }

    private Uni<TenantConfigContext> getDynamicTenantContext(RoutingContext context) {
        return this.getDynamicTenantConfig(context).chain((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    boolean isEnableHttpForwardedPrefix() {
        return this.enableHttpForwardedPrefix;
    }

    public Map<String, BackChannelLogoutTokenCache> getBackChannelLogoutTokens() {
        return this.backChannelLogoutTokens;
    }

    public TenantConfigBean getTenantConfigBean() {
        return this.tenantConfigBean;
    }

    public JavaScriptRequestChecker getJavaScriptRequestChecker() {
        return this.javaScriptRequestChecker.isResolvable() ? (JavaScriptRequestChecker)this.javaScriptRequestChecker.get() : null;
    }

    public OidcTenantConfig getResolvedConfig(String sessionTenantId) {
        if ("Default".equals(sessionTenantId)) {
            return this.tenantConfigBean.getDefaultTenant().getOidcTenantConfig();
        }
        TenantConfigContext tenant = this.tenantConfigBean.getStaticTenant(sessionTenantId);
        if (tenant == null) {
            tenant = this.tenantConfigBean.getDynamicTenant(sessionTenantId);
        }
        return tenant != null ? tenant.getOidcTenantConfig() : null;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public DefaultTenantConfigResolver() {
    }
}

