/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.transactional;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.entity.EntityNameLookupRecord;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisChangeTrackingVersions;
import org.apache.polaris.core.entity.PolarisEntitiesActiveKey;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityId;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.persistence.BasePersistence;
import org.apache.polaris.core.persistence.IntegrationPersistence;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.policy.TransactionalPolicyMappingPersistence;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageIntegration;

public interface TransactionalPersistence
extends BasePersistence,
IntegrationPersistence,
TransactionalPolicyMappingPersistence {
    public <T> T runInTransaction(@Nonnull PolarisCallContext var1, @Nonnull Supplier<T> var2);

    public void runActionInTransaction(@Nonnull PolarisCallContext var1, @Nonnull Runnable var2);

    public <T> T runInReadTransaction(@Nonnull PolarisCallContext var1, @Nonnull Supplier<T> var2);

    public void runActionInReadTransaction(@Nonnull PolarisCallContext var1, @Nonnull Runnable var2);

    @Nonnull
    public List<EntityNameLookupRecord> lookupEntityActiveBatchInCurrentTxn(@Nonnull PolarisCallContext var1, List<PolarisEntitiesActiveKey> var2);

    public void rollback();

    public long generateNewIdInCurrentTxn(@Nonnull PolarisCallContext var1);

    public void writeEntityInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull PolarisBaseEntity var2, boolean var3, @Nullable PolarisBaseEntity var4);

    public void writeEntitiesInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull List<PolarisBaseEntity> var2, @Nullable List<PolarisBaseEntity> var3);

    public void writeToGrantRecordsInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull PolarisGrantRecord var2);

    public void deleteEntityInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull PolarisBaseEntity var2);

    public void deleteFromGrantRecordsInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull PolarisGrantRecord var2);

    public void deleteAllEntityGrantRecordsInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull PolarisEntityCore var2, @Nonnull List<PolarisGrantRecord> var3, @Nonnull List<PolarisGrantRecord> var4);

    public void deleteAllInCurrentTxn(@Nonnull PolarisCallContext var1);

    @Nullable
    public PolarisBaseEntity lookupEntityInCurrentTxn(@Nonnull PolarisCallContext var1, long var2, long var4, int var6);

    @Nullable
    public PolarisBaseEntity lookupEntityByNameInCurrentTxn(@Nonnull PolarisCallContext var1, long var2, long var4, int var6, @Nonnull String var7);

    @Nullable
    public EntityNameLookupRecord lookupEntityIdAndSubTypeByNameInCurrentTxn(@Nonnull PolarisCallContext var1, long var2, long var4, int var6, @Nonnull String var7);

    @Nonnull
    public List<PolarisBaseEntity> lookupEntitiesInCurrentTxn(@Nonnull PolarisCallContext var1, List<PolarisEntityId> var2);

    @Nonnull
    public List<PolarisChangeTrackingVersions> lookupEntityVersionsInCurrentTxn(@Nonnull PolarisCallContext var1, List<PolarisEntityId> var2);

    @Nonnull
    public Page<EntityNameLookupRecord> listEntitiesInCurrentTxn(@Nonnull PolarisCallContext var1, long var2, long var4, @Nonnull PolarisEntityType var6, @Nonnull PageToken var7);

    @Nonnull
    public Page<EntityNameLookupRecord> listEntitiesInCurrentTxn(@Nonnull PolarisCallContext var1, long var2, long var4, @Nonnull PolarisEntityType var6, @Nonnull Predicate<PolarisBaseEntity> var7, @Nonnull PageToken var8);

    @Nonnull
    public <T> Page<T> listEntitiesInCurrentTxn(@Nonnull PolarisCallContext var1, long var2, long var4, @Nonnull PolarisEntityType var6, @Nonnull Predicate<PolarisBaseEntity> var7, @Nonnull Function<PolarisBaseEntity, T> var8, @Nonnull PageToken var9);

    public int lookupEntityGrantRecordsVersionInCurrentTxn(@Nonnull PolarisCallContext var1, long var2, long var4);

    @Nullable
    public PolarisGrantRecord lookupGrantRecordInCurrentTxn(@Nonnull PolarisCallContext var1, long var2, long var4, long var6, long var8, int var10);

    @Nonnull
    public List<PolarisGrantRecord> loadAllGrantRecordsOnSecurableInCurrentTxn(@Nonnull PolarisCallContext var1, long var2, long var4);

    @Nonnull
    public List<PolarisGrantRecord> loadAllGrantRecordsOnGranteeInCurrentTxn(@Nonnull PolarisCallContext var1, long var2, long var4);

    public boolean hasChildrenInCurrentTxn(@Nonnull PolarisCallContext var1, @Nullable PolarisEntityType var2, long var3, long var5);

    @Nullable
    public PolarisPrincipalSecrets loadPrincipalSecretsInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull String var2);

    @Nonnull
    public PolarisPrincipalSecrets generateNewPrincipalSecretsInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull String var2, long var3);

    @Nullable
    public PolarisPrincipalSecrets rotatePrincipalSecretsInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull String var2, long var3, boolean var5, @Nonnull String var6);

    public void deletePrincipalSecretsInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull String var2, long var3);

    @Nullable
    public <T extends PolarisStorageConfigurationInfo> PolarisStorageIntegration<T> createStorageIntegrationInCurrentTxn(@Nonnull PolarisCallContext var1, long var2, long var4, PolarisStorageConfigurationInfo var6);

    public <T extends PolarisStorageConfigurationInfo> void persistStorageIntegrationIfNeededInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull PolarisBaseEntity var2, @Nullable PolarisStorageIntegration<T> var3);

    @Nullable
    public <T extends PolarisStorageConfigurationInfo> PolarisStorageIntegration<T> loadPolarisStorageIntegrationInCurrentTxn(@Nonnull PolarisCallContext var1, @Nonnull PolarisBaseEntity var2);
}

