/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.http;

import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.olingo.client.api.http.WrappingHttpClientFactory;
import org.apache.olingo.client.core.http.DefaultHttpClientFactory;
import org.apache.olingo.commons.api.http.HttpMethod;

public class ProxyWrappingHttpClientFactory
implements WrappingHttpClientFactory {
    private final URI proxy;
    private String proxyUsername;
    private String proxyPassword;
    private final DefaultHttpClientFactory wrapped;

    public ProxyWrappingHttpClientFactory(URI proxy) {
        this(proxy, null, null, new DefaultHttpClientFactory());
    }

    public ProxyWrappingHttpClientFactory(URI proxy, String proxyUsername, String proxyPassword) {
        this(proxy, proxyUsername, proxyPassword, new DefaultHttpClientFactory());
    }

    public ProxyWrappingHttpClientFactory(URI proxy, DefaultHttpClientFactory wrapped) {
        this(proxy, null, null, wrapped);
    }

    public ProxyWrappingHttpClientFactory(URI proxy, String proxyUsername, String proxyPassword, DefaultHttpClientFactory wrapped) {
        this.proxy = proxy;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.wrapped = wrapped;
    }

    public DefaultHttpClientFactory getWrappedHttpClientFactory() {
        return this.wrapped;
    }

    public HttpClient create(HttpMethod method, URI uri) {
        DefaultHttpClient httpclient = this.wrapped.create(method, uri);
        HttpHost proxyHost = new HttpHost(this.proxy.getHost(), this.proxy.getPort());
        httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
        if (this.proxyUsername != null && this.proxyPassword != null) {
            httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword));
        }
        return httpclient;
    }

    public void close(HttpClient httpClient) {
        this.wrapped.close(httpClient);
    }
}

