/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.cache;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.plugin.base.handler.DiscoveryUpstreamDataHandler;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;

public class CommonDiscoveryUpstreamDataSubscriber
implements DiscoveryUpstreamDataSubscriber {
    private final Map<String, DiscoveryUpstreamDataHandler> handlerMap;

    public CommonDiscoveryUpstreamDataSubscriber(List<DiscoveryUpstreamDataHandler> discoveryUpstreamDataHandlers) {
        this.handlerMap = discoveryUpstreamDataHandlers.stream().collect(Collectors.toConcurrentMap(DiscoveryUpstreamDataHandler::pluginName, e -> e));
    }

    public void onSubscribe(DiscoverySyncData upstreamDataList) {
        Optional.ofNullable(this.handlerMap.get(upstreamDataList.getPluginName())).ifPresent(handler -> handler.handlerDiscoveryUpstreamData(upstreamDataList));
    }

    public void unSubscribe(DiscoverySyncData upstreamDataList) {
    }
}

