/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive.error;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.AbstractErrorWebExceptionHandler;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultErrorWebExceptionHandler
extends AbstractErrorWebExceptionHandler {
    private static final MediaType TEXT_HTML_UTF8 = new MediaType("text", "html", StandardCharsets.UTF_8);
    private static final Map<HttpStatus.Series, String> SERIES_VIEWS;
    private static final ErrorAttributeOptions ONLY_STATUS;
    private final ErrorProperties errorProperties;

    public DefaultErrorWebExceptionHandler(ErrorAttributes errorAttributes, WebProperties.Resources resources, ErrorProperties errorProperties, ApplicationContext applicationContext) {
        super(errorAttributes, resources, applicationContext);
        this.errorProperties = errorProperties;
    }

    @Override
    protected RouterFunction<ServerResponse> getRoutingFunction(ErrorAttributes errorAttributes) {
        return RouterFunctions.route((RequestPredicate)this.acceptsTextHtml(), this::renderErrorView).andRoute(RequestPredicates.all(), this::renderErrorResponse);
    }

    protected Mono<ServerResponse> renderErrorView(ServerRequest request) {
        int status = this.getHttpStatus(this.getErrorAttributes(request, ONLY_STATUS));
        Map<String, Object> errorAttributes = this.getErrorAttributes(request, MediaType.TEXT_HTML);
        ServerResponse.BodyBuilder responseBody = ServerResponse.status((int)status).contentType(TEXT_HTML_UTF8);
        return Flux.just((Object[])this.getData(status).toArray(new String[0])).flatMap(viewName -> this.renderErrorView((String)viewName, responseBody, errorAttributes)).switchIfEmpty((Publisher)(this.errorProperties.getWhitelabel().isEnabled() ? this.renderDefaultErrorView(responseBody, errorAttributes) : Mono.error((Throwable)this.getError(request)))).next();
    }

    private List<String> getData(int errorStatus) {
        ArrayList<String> data = new ArrayList<String>();
        data.add("error/" + errorStatus);
        HttpStatus.Series series = HttpStatus.Series.resolve((int)errorStatus);
        if (series != null) {
            data.add("error/" + SERIES_VIEWS.get(series));
        }
        data.add("error/error");
        return data;
    }

    protected Mono<ServerResponse> renderErrorResponse(ServerRequest request) {
        int status = this.getHttpStatus(this.getErrorAttributes(request, ONLY_STATUS));
        Map<String, Object> errorAttributes = this.getErrorAttributes(request, MediaType.ALL);
        return ServerResponse.status((int)status).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue(errorAttributes));
    }

    private Map<String, Object> getErrorAttributes(ServerRequest request, MediaType mediaType) {
        return this.getErrorAttributes(request, this.getErrorAttributeOptions(request, mediaType));
    }

    protected ErrorAttributeOptions getErrorAttributeOptions(ServerRequest request, MediaType mediaType) {
        ErrorAttributeOptions options = ErrorAttributeOptions.defaults();
        if (this.errorProperties.isIncludeException()) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.EXCEPTION});
        }
        if (this.isIncludeStackTrace(request, mediaType)) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.STACK_TRACE});
        }
        if (this.isIncludeMessage(request, mediaType)) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.MESSAGE});
        }
        if (this.isIncludeBindingErrors(request, mediaType)) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.BINDING_ERRORS});
        }
        options = this.isIncludePath(request, mediaType) ? options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.PATH}) : options.excluding(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.PATH});
        return options;
    }

    protected boolean isIncludeStackTrace(ServerRequest request, MediaType produces) {
        return switch (this.errorProperties.getIncludeStacktrace()) {
            default -> throw new IncompatibleClassChangeError();
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.isTraceEnabled(request);
            case ErrorProperties.IncludeAttribute.NEVER -> false;
        };
    }

    protected boolean isIncludeMessage(ServerRequest request, MediaType produces) {
        return switch (this.errorProperties.getIncludeMessage()) {
            default -> throw new IncompatibleClassChangeError();
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.isMessageEnabled(request);
            case ErrorProperties.IncludeAttribute.NEVER -> false;
        };
    }

    protected boolean isIncludeBindingErrors(ServerRequest request, MediaType produces) {
        return switch (this.errorProperties.getIncludeBindingErrors()) {
            default -> throw new IncompatibleClassChangeError();
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.isBindingErrorsEnabled(request);
            case ErrorProperties.IncludeAttribute.NEVER -> false;
        };
    }

    protected boolean isIncludePath(ServerRequest request, MediaType produces) {
        return switch (this.errorProperties.getIncludePath()) {
            default -> throw new IncompatibleClassChangeError();
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.isPathEnabled(request);
            case ErrorProperties.IncludeAttribute.NEVER -> false;
        };
    }

    protected int getHttpStatus(Map<String, Object> errorAttributes) {
        Object status = errorAttributes.get("status");
        Assert.state((boolean)(status instanceof Integer), (String)"ErrorAttributes must contain a status integer");
        return (Integer)status;
    }

    protected RequestPredicate acceptsTextHtml() {
        return serverRequest -> {
            try {
                List acceptedMediaTypes = serverRequest.headers().accept();
                acceptedMediaTypes.removeIf(arg_0 -> ((MediaType)MediaType.ALL).equalsTypeAndSubtype(arg_0));
                MimeTypeUtils.sortBySpecificity((List)acceptedMediaTypes);
                return acceptedMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)MediaType.TEXT_HTML).isCompatibleWith(arg_0));
            }
            catch (InvalidMediaTypeException ex) {
                return false;
            }
        };
    }

    static {
        EnumMap<HttpStatus.Series, String> views = new EnumMap<HttpStatus.Series, String>(HttpStatus.Series.class);
        views.put(HttpStatus.Series.CLIENT_ERROR, "4xx");
        views.put(HttpStatus.Series.SERVER_ERROR, "5xx");
        SERIES_VIEWS = Collections.unmodifiableMap(views);
        ONLY_STATUS = ErrorAttributeOptions.of((ErrorAttributeOptions.Include[])new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.STATUS});
    }
}

