/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.inflater;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.pending.jdk.JDK18;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.geotiff.base.Resources;
import org.apache.sis.storage.geotiff.inflater.PixelChannel;

abstract class CompressionChannel
extends PixelChannel {
    private static final int BUFFER_SIZE = 16384;
    protected final ChannelDataInput input;
    private long endPosition;
    protected final StoreListeners listeners;

    protected CompressionChannel(ChannelDataInput input, StoreListeners listeners) {
        this.input = input;
        this.listeners = listeners;
    }

    @Override
    public void setInputRegion(long start, long byteCount) throws IOException {
        this.endPosition = Math.addExact(start, byteCount);
        this.input.seek(start);
        this.input.rangeOfInterest(start, this.endPosition);
    }

    protected final boolean finished() {
        return this.input.getStreamPosition() >= this.endPosition;
    }

    final ChannelDataInput createDataInput(PixelChannel channel, int scanlineStride, boolean directBuffer) throws IOException {
        int capacity;
        if (scanlineStride > 16384) {
            int[] divisors = MathFunctions.divisors((int)scanlineStride);
            int i = Arrays.binarySearch(divisors, 16384);
            if (i < 0) {
                i ^= 0xFFFFFFFF;
            }
            capacity = divisors[i];
        } else {
            capacity = JDK18.ceilDiv((int)16384, (int)scanlineStride) * scanlineStride;
        }
        ByteBuffer buffer = directBuffer ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        buffer = buffer.order(this.input.buffer.order()).limit(0);
        return new ChannelDataInput(this.input.filename, (ReadableByteChannel)channel, buffer, true);
    }

    static void repeat(ByteBuffer target, byte b, int n) {
        while (--n >= 0) {
            target.put(b);
        }
    }

    @Override
    public final boolean isOpen() {
        return this.input.channel.isOpen();
    }

    @Override
    public void close() {
    }

    final Resources resources() {
        return Resources.forLocale(this.listeners.getLocale());
    }
}

