/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.io.IOException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.virtualization.ObjectSerializer;
import net.sf.jasperreports.engine.virtualization.ReferenceType;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class StringSerializer
implements ObjectSerializer<String> {
    public static final String EXCEPTION_MESSAGE_KEY_CHUNK_UNEXPECTED_LENGTH = "virtualization.chunk.unexpected.length";
    public static final String EXCEPTION_MESSAGE_KEY_CHUNK_UNEXPECTED_LENGTH_REMAINING = "virtualization.chunk.unexpected.length.remaining";
    private static final int CHUNK_SIZE = 20000;

    @Override
    public int typeValue() {
        return 16;
    }

    @Override
    public ReferenceType defaultReferenceType() {
        return ReferenceType.OBJECT;
    }

    @Override
    public boolean defaultStoreReference() {
        return true;
    }

    @Override
    public void write(String value, VirtualizationOutput out) throws IOException {
        int length = value.length();
        if (length < 20000) {
            out.writeUTF(value);
        } else {
            out.writeUTF(value.substring(0, 20000));
            out.writeInt(length);
            for (int index = 20000; index < length; index += 20000) {
                out.writeUTF(value.substring(index, Math.min(length, index + 20000)));
            }
        }
    }

    @Override
    public String read(VirtualizationInput in) throws IOException {
        String chunk = in.readUTF();
        int chunkLength = chunk.length();
        if (chunkLength < 20000) {
            return chunk;
        }
        if (chunkLength != 20000) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CHUNK_UNEXPECTED_LENGTH, chunkLength);
        }
        int length = in.readInt();
        if (length < 20000) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CHUNK_UNEXPECTED_LENGTH, length);
        }
        char[] chars = new char[length];
        chunk.getChars(0, chunkLength, chars, 0);
        for (int remaining = length - chunkLength; remaining > 0; remaining -= chunkLength) {
            chunk = in.readUTF();
            chunkLength = chunk.length();
            if (chunkLength < 20000) {
                if (chunkLength != remaining) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CHUNK_UNEXPECTED_LENGTH_REMAINING, chunkLength, remaining);
                }
            } else if (chunkLength != 20000) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CHUNK_UNEXPECTED_LENGTH, chunkLength);
            }
            chunk.getChars(0, chunkLength, chars, length - remaining);
        }
        return new String(chars);
    }
}

