/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.events.CustomEvent;
import org.apache.batik.dom.events.EventListenerList;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.dom.xbl.OriginalEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class EventSupport {
    protected HashTable capturingListeners;
    protected HashTable bubblingListeners;
    protected AbstractNode node;
    static /* synthetic */ Class class$org$w3c$dom$events$EventTarget;

    public EventSupport(AbstractNode abstractNode) {
        this.node = abstractNode;
    }

    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        this.addEventListenerNS(null, string, eventListener, bl, null);
    }

    public void addEventListenerNS(String string, String string2, EventListener eventListener, boolean bl, Object object) {
        HashTable hashTable;
        if (bl) {
            if (this.capturingListeners == null) {
                this.capturingListeners = new HashTable();
            }
            hashTable = this.capturingListeners;
        } else {
            if (this.bubblingListeners == null) {
                this.bubblingListeners = new HashTable();
            }
            hashTable = this.bubblingListeners;
        }
        EventListenerList eventListenerList = (EventListenerList)hashTable.get(string2);
        if (eventListenerList == null) {
            eventListenerList = new EventListenerList();
            hashTable.put(string2, eventListenerList);
        }
        eventListenerList.addListener(string, object, eventListener);
    }

    public void removeEventListener(String string, EventListener eventListener, boolean bl) {
        this.removeEventListenerNS(null, string, eventListener, bl);
    }

    public void removeEventListenerNS(String string, String string2, EventListener eventListener, boolean bl) {
        HashTable hashTable = bl ? this.capturingListeners : this.bubblingListeners;
        if (hashTable == null) {
            return;
        }
        EventListenerList eventListenerList = (EventListenerList)hashTable.get(string2);
        if (eventListenerList != null) {
            eventListenerList.removeListener(string, eventListener);
            if (eventListenerList.size() == 0) {
                hashTable.remove(string2);
            }
        }
    }

    public void moveEventListeners(EventSupport eventSupport) {
        eventSupport.capturingListeners = this.capturingListeners;
        eventSupport.bubblingListeners = this.bubblingListeners;
        this.capturingListeners = null;
        this.bubblingListeners = null;
    }

    public boolean dispatchEvent(NodeEventTarget nodeEventTarget, Event event) throws EventException {
        NodeEventTarget nodeEventTarget2;
        int n;
        boolean bl;
        if (event == null) {
            return false;
        }
        AbstractEvent abstractEvent = null;
        CustomEvent customEvent = null;
        if (event instanceof CustomEvent) {
            bl = true;
            customEvent = (CustomEvent)((Object)event);
        } else if (event instanceof org.w3c.dom.events.CustomEvent) {
            bl = true;
            customEvent = new WrappedEvent((org.w3c.dom.events.CustomEvent)event);
        } else if (event instanceof AbstractEvent) {
            bl = false;
            abstractEvent = (AbstractEvent)event;
        } else {
            throw this.createEventException((short)9, "unsupported.event", new Object[0]);
        }
        String string = event.getType();
        if (string == null || string.length() == 0) {
            throw this.createEventException((short)0, "unspecified.event", new Object[0]);
        }
        if (!bl) {
            abstractEvent.setTarget(nodeEventTarget);
            abstractEvent.stopPropagation(false);
            abstractEvent.stopImmediatePropagation(false);
            abstractEvent.preventDefault(false);
        } else {
            customEvent.setTarget(nodeEventTarget);
        }
        NodeEventTarget[] nodeEventTargetArray = this.getAncestors(nodeEventTarget);
        if (!bl) {
            abstractEvent.setEventPhase((short)1);
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        for (n = 0; n < nodeEventTargetArray.length; ++n) {
            nodeEventTarget2 = nodeEventTargetArray[n];
            if (bl) {
                customEvent.setDispatchState(nodeEventTarget2, (short)1);
            } else {
                abstractEvent.setCurrentTarget(nodeEventTarget2);
            }
            this.fireEventListeners(nodeEventTarget2, event, true, hashSet, hashSet2, bl);
            hashSet.addAll(hashSet2);
            hashSet2.clear();
        }
        if (bl) {
            customEvent.setDispatchState(nodeEventTarget, (short)2);
        } else {
            abstractEvent.setEventPhase((short)2);
            abstractEvent.setCurrentTarget(nodeEventTarget);
        }
        this.fireEventListeners(nodeEventTarget, event, false, hashSet, hashSet2, bl);
        hashSet.addAll(hashSet2);
        hashSet2.clear();
        if (event.getBubbles()) {
            if (!bl) {
                abstractEvent.setEventPhase((short)3);
            }
            for (n = nodeEventTargetArray.length - 1; n >= 0; --n) {
                nodeEventTarget2 = nodeEventTargetArray[n];
                if (bl) {
                    customEvent.setDispatchState(nodeEventTarget2, (short)3);
                } else {
                    abstractEvent.setCurrentTarget(nodeEventTarget2);
                }
                this.fireEventListeners(nodeEventTarget2, event, false, hashSet, hashSet2, bl);
                hashSet.addAll(hashSet2);
                hashSet2.clear();
            }
        }
        return bl ? customEvent.isDefaultPrevented() : abstractEvent.isDefaultPrevented();
    }

    protected void fireEventListeners(NodeEventTarget nodeEventTarget, Event event, EventListenerList.Entry[] entryArray, HashSet hashSet, HashSet hashSet2, boolean bl) {
        String string;
        if (entryArray == null) {
            return;
        }
        CustomEvent customEvent = null;
        AbstractEvent abstractEvent = null;
        if (bl) {
            customEvent = (CustomEvent)((Object)event);
            string = customEvent.getNamespaceURI();
        } else {
            abstractEvent = (AbstractEvent)event;
            string = abstractEvent.getNamespaceURI();
        }
        for (int i = 0; i < entryArray.length; ++i) {
            try {
                String string2 = entryArray[i].getNamespaceURI();
                if (string2 != null && string != null && !string2.equals(string)) continue;
                Object object = entryArray[i].getGroup();
                if (hashSet != null && hashSet.contains(object)) continue;
                entryArray[i].getListener().handleEvent(event);
                if (bl) {
                    if (customEvent.isImmediatePropagationStopped()) {
                        if (hashSet != null) {
                            hashSet.add(object);
                        }
                        customEvent.resumePropagation();
                        continue;
                    }
                    if (!customEvent.isPropagationStopped()) continue;
                    if (hashSet2 != null) {
                        hashSet2.add(object);
                    }
                    customEvent.resumePropagation();
                    continue;
                }
                if (abstractEvent.getStopImmediatePropagation()) {
                    if (hashSet != null) {
                        hashSet.add(object);
                    }
                    abstractEvent.stopImmediatePropagation(false);
                    continue;
                }
                if (!abstractEvent.getStopPropagation()) continue;
                if (hashSet2 != null) {
                    hashSet2.add(object);
                }
                abstractEvent.stopPropagation(false);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected void fireEventListeners(NodeEventTarget nodeEventTarget, Event event, boolean bl, HashSet hashSet, HashSet hashSet2, boolean bl2) {
        String string = event.getType();
        EventSupport eventSupport = nodeEventTarget.getEventSupport();
        if (eventSupport == null) {
            return;
        }
        EventListenerList eventListenerList = eventSupport.getEventListeners(string, bl);
        if (eventListenerList == null) {
            return;
        }
        EventListenerList.Entry[] entryArray = eventListenerList.getEventListeners();
        this.fireEventListeners(nodeEventTarget, event, entryArray, hashSet, hashSet2, bl2);
    }

    protected NodeEventTarget[] getAncestors(NodeEventTarget object) {
        object = object.getParentNodeEventTarget();
        int n = 0;
        NodeEventTarget[] nodeEventTargetArray = object;
        while (nodeEventTargetArray != null) {
            nodeEventTargetArray = nodeEventTargetArray.getParentNodeEventTarget();
            ++n;
        }
        nodeEventTargetArray = new NodeEventTarget[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            nodeEventTargetArray[n2] = object;
            --n2;
            object = object.getParentNodeEventTarget();
        }
        return nodeEventTargetArray;
    }

    public boolean hasEventListenerNS(String string, String string2) {
        EventListenerList eventListenerList;
        if (this.capturingListeners != null && (eventListenerList = (EventListenerList)this.capturingListeners.get(string2)) != null && eventListenerList.hasEventListener(string)) {
            return true;
        }
        if (this.bubblingListeners != null && (eventListenerList = (EventListenerList)this.capturingListeners.get(string2)) != null) {
            return eventListenerList.hasEventListener(string);
        }
        return false;
    }

    public EventListenerList getEventListeners(String string, boolean bl) {
        HashTable hashTable;
        HashTable hashTable2 = hashTable = bl ? this.capturingListeners : this.bubblingListeners;
        if (hashTable == null) {
            return null;
        }
        return (EventListenerList)hashTable.get(string);
    }

    protected EventException createEventException(short s, String string, Object[] objectArray) {
        try {
            AbstractDocument abstractDocument = (AbstractDocument)this.node.getOwnerDocument();
            return new EventException(s, abstractDocument.formatMessage(string, objectArray));
        }
        catch (Exception exception) {
            return new EventException(s, string);
        }
    }

    protected void setTarget(AbstractEvent abstractEvent, NodeEventTarget nodeEventTarget) {
        abstractEvent.setTarget(nodeEventTarget);
    }

    protected void stopPropagation(AbstractEvent abstractEvent, boolean bl) {
        abstractEvent.stopPropagation(bl);
    }

    protected void stopImmediatePropagation(AbstractEvent abstractEvent, boolean bl) {
        abstractEvent.stopImmediatePropagation(bl);
    }

    protected void preventDefault(AbstractEvent abstractEvent, boolean bl) {
        abstractEvent.preventDefault(bl);
    }

    protected void setCurrentTarget(AbstractEvent abstractEvent, NodeEventTarget nodeEventTarget) {
        abstractEvent.setCurrentTarget(nodeEventTarget);
    }

    protected void setEventPhase(AbstractEvent abstractEvent, short s) {
        abstractEvent.setEventPhase(s);
    }

    public static Event getUltimateOriginalEvent(Event event) {
        while (true) {
            Event event2;
            OriginalEvent originalEvent;
            if (event instanceof AbstractEvent) {
                originalEvent = (AbstractEvent)event;
                event2 = ((AbstractEvent)originalEvent).getOriginalEvent();
                if (event2 == null) break;
                event = event2;
                continue;
            }
            if (!(event instanceof CustomEvent) || (event2 = (originalEvent = (CustomEvent)((Object)event)).getOriginalEvent()) == null) break;
            event = event2;
        }
        return event;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class WrappedEvent
    implements CustomEvent {
        protected org.w3c.dom.events.CustomEvent e;
        protected Method getNamespaceURIMethod;
        protected Method stopImmediatePropagationMethod;
        protected Method isDefaultPreventedMethod;
        protected Method resumePropagationMethod;
        protected Method retargetMethod;
        protected Method setTargetMethod;
        protected Method getOriginalEventMethod;

        public WrappedEvent(org.w3c.dom.events.CustomEvent customEvent) {
            this.e = customEvent;
            Class<?> clazz = customEvent.getClass();
            try {
                this.getNamespaceURIMethod = clazz.getMethod("getNamespaceURI", null);
                this.stopImmediatePropagationMethod = clazz.getMethod("stopImmediatePropagation", null);
                this.isDefaultPreventedMethod = clazz.getMethod("isDefaultPrevented", null);
                this.resumePropagationMethod = clazz.getMethod("resumePropagation", null);
                this.setTargetMethod = clazz.getMethod("setTarget", class$org$w3c$dom$events$EventTarget == null ? (class$org$w3c$dom$events$EventTarget = EventSupport.class$("org.w3c.dom.events.EventTarget")) : class$org$w3c$dom$events$EventTarget);
                this.retargetMethod = clazz.getMethod("retarget", class$org$w3c$dom$events$EventTarget == null ? (class$org$w3c$dom$events$EventTarget = EventSupport.class$("org.w3c.dom.events.EventTarget")) : class$org$w3c$dom$events$EventTarget);
                this.getOriginalEventMethod = clazz.getMethod("getOriginalEvent", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw EventSupport.this.createEventException((short)9, "unsupported.event", new Object[0]);
            }
            catch (SecurityException securityException) {
                throw EventSupport.this.createEventException((short)9, "unsupported.event", new Object[0]);
            }
        }

        public String getType() {
            return this.e.getType();
        }

        public EventTarget getCurrentTarget() {
            return this.e.getCurrentTarget();
        }

        public EventTarget getTarget() {
            return this.e.getTarget();
        }

        public short getEventPhase() {
            return this.e.getEventPhase();
        }

        public boolean getBubbles() {
            return this.e.getBubbles();
        }

        public boolean getCancelable() {
            return this.e.getCancelable();
        }

        public long getTimeStamp() {
            return this.e.getTimeStamp();
        }

        public void stopPropagation() {
            this.e.stopPropagation();
        }

        public void preventDefault() {
            this.e.preventDefault();
        }

        public void initEvent(String string, boolean bl, boolean bl2) {
            this.e.initEvent(string, bl, bl2);
        }

        public void setDispatchState(EventTarget eventTarget, short s) {
            this.e.setDispatchState(eventTarget, s);
        }

        public boolean isPropagationStopped() {
            return this.e.isPropagationStopped();
        }

        public boolean isImmediatePropagationStopped() {
            return this.e.isImmediatePropagationStopped();
        }

        public void resumePropagation() {
            try {
                this.resumePropagationMethod.invoke((Object)this.e, (Object[])null);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }

        public void setTarget(EventTarget eventTarget) {
            try {
                this.setTargetMethod.invoke((Object)this.e, eventTarget);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }

        public CustomEvent retarget(EventTarget eventTarget) {
            try {
                return new WrappedEvent((org.w3c.dom.events.CustomEvent)this.retargetMethod.invoke((Object)this.e, eventTarget));
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }

        public Event getOriginalEvent() {
            try {
                return (Event)this.getOriginalEventMethod.invoke((Object)this.e, (Object[])null);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }

        public String getNamespaceURI() {
            try {
                return (String)this.getNamespaceURIMethod.invoke((Object)this.e, (Object[])null);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }

        public boolean isCustom() {
            return true;
        }

        public void stopImmediatePropagation() {
            try {
                this.stopImmediatePropagationMethod.invoke((Object)this.e, (Object[])null);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }

        public boolean isDefaultPrevented() {
            try {
                Boolean bl = (Boolean)this.isDefaultPreventedMethod.invoke((Object)this.e, (Object[])null);
                return bl;
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return false;
        }

        public void initEventNS(String string, String string2, boolean bl, boolean bl2) {
        }
    }
}

